<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\User $user
 */

//$this->layout = 'login';
$this->assign('title', 'Register new user');
?>

<div class="row">
    <div class="column column-50 column-offset-25">
        <div class="form content form-container">

            <?= $this->Form->create($user) ?>

            <fieldset>
                <legend class="form-title">Register new user</legend>

                <?= $this->Flash->render() ?>

                <?= $this->Form->control('email',[
                    'templateVars' => ['container_class' => 'column'],
                    'maxlength' => 30,
                    'required' => true,
                    'type' => 'email',
                    'placeholder' => 'test@fitieadmin.com'
                ]); ?>

                <div class="row">
                    <?= $this->Form->control('first_name',
                        [
                            'templateVars' => ['container_class' => 'column'],
                            'maxlength' => 30,
                            'required' => true,
                            'type' => 'text',
                        ]); ?>
                    <?= $this->Form->control('last_name', [
                        'templateVars' => ['container_class' => 'column'],
                        'maxlength' => 30,
                        'required' => true,
                        'type' => 'text',
                    ]); ?>
                </div>

                <div class="row">
                    <?php
                    echo $this->Form->control('password', [
                        'value' => '',  // Ensure password is not sending back to the client side
                        'templateVars' => ['container_class' => 'column'],
                        'maxlength' => 30,

                    ]);
                    // Validate password by repeating it
                    echo $this->Form->control('password_confirm', [
                        'type' => 'password',
                        'value' => '',  // Ensure password is not sending back to the client side
                        'label' => 'Retype Password',
                        'maxlength' => 30,
                        'templateVars' => ['container_class' => 'column']
                    ]);
                    ?>
                </div>

                <?= $this->Form->control('avatar', ['type' => 'file']); ?>

            </fieldset>

            <?= $this->Form->button('Register',['class'=>'secondary-button']) ?>

            <?= $this->Html->link('Back to login',
                ['controller' => 'Auth', 'action' => 'login'],['class'=>'secondary-button']) ?>

            <?= $this->Form->end() ?>

        </div>
    </div>
</div>

