<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\ContactForm $contactForm
 */
?>

<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow-lg">
                <div class="card-header text-white">
                    <h3 class="mb-0">Contact Form Details</h3>
                </div>
                <div class="card-body">
                    <table class="table">
                        <tbody>
                            <tr>
                                <th class="w-25">Name</th>
                                <td><?= h($contactForm->name) ?></td>
                            </tr>
                            <tr>
                                <th>Email</th>
                                <td><?= h($contactForm->email) ?></td>
                            </tr>
                            <tr>
                                <th>ID</th>
                                <td><?= $this->Number->format($contactForm->id) ?></td>
                            </tr>
                            <tr>
                                <th>Created</th>
                                <td><?= h($contactForm->created) ?></td>
                            </tr>
                        </tbody>
                    </table>
                    <div class="mt-4">
                        <h5 class="text-primary">Message</h5>
                        <blockquote class="blockquote p-3 border rounded bg-light">
                            <?= $this->Text->autoParagraph(h($contactForm->message)); ?>
                        </blockquote>
                    </div>
                </div>
                <div class="card-footer text-end">
                    <a href="<?= $this->Url->build(['action' => 'index']) ?>" class="btn btn-secondary">Back</a>
                </div>
            </div>
        </div>
    </div>
</div>