<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\User> $users
 */
$this->assign('title', 'Manage Users');
$tz = 'Australia/Melbourne';

$identity = $this->request->getAttribute('identity');
$currentIsSuper = (bool)($identity && ($identity->role === 'super'));
?>
<style>
    .users.index .page{max-width:1100px;margin:32px auto;padding:0 16px}
    .users.index .card{background:#fff;border:1px solid #eaeaea;border-radius:16px;box-shadow:0 6px 24px rgba(0,0,0,.06)}
    .users.index .header{display:flex;align-items:center;justify-content:space-between;gap:16px;padding:16px 18px}
    .users.index .header-left{display:flex;align-items:center;gap:12px}
    .users.index .title{margin:0;font-size:1.24rem;font-weight:800;color:#0f172a}
    .users.index .subtitle{margin:0;color:#64748b;font-size:.95rem}
    .users.index .back-btn{display:inline-flex;align-items:center;gap:8px;padding:8px 12px;border:1px solid #e5e7eb;border-radius:10px;background:#f8fafc;color:#334155;font-weight:600;text-decoration:none}
    .users.index .back-btn:hover{background:#eef2ff}
    .users.index .primary-btn{background:#111827;color:#fff;border:1px solid #111827;border-radius:12px;padding:10px 14px;font-weight:700;text-decoration:none}

    .users.index .table-wrap{border-top:1px solid #f3f4f6;background:#fff}
    .users.index .table-frame{padding:12px 18px 18px}
    .users.index .table-responsive{overflow-x:auto;border:1px solid #eef2f7;border-radius:14px}
    .users.index table {
        border-bottom: 1px solid #e91e63;
    }
    .users.index thead th{background:#fff;color:#334155;font-weight:800;font-size:.9rem;text-align:left;padding:12px 14px;border-bottom:1px solid #eaeef5;white-space:nowrap}
    .users.index tbody td{padding:12px 14px;border-top:1px solid #f3f4f7;vertical-align:middle}
    .users.index tbody tr:last-child td {
        border-bottom: 1px solid #e91e63;
    }
    .users.index .mono{font-family:ui-monospace,SFMono-Regular,Menlo,Monaco,Consolas,"Liberation Mono",monospace}

    .badge-role{display:inline-block;padding:4px 10px;border-radius:999px;font-weight:800;font-size:.8rem}
    .badge-super{background:#dbeafe;color:#1e40af;border:1px solid #bfdbfe}
    .badge-admin{background:#ecfdf5;color:#065f46;border:1px solid #d1fae5}

    .users.index td.actions{white-space:nowrap}
    .users.index td.actions a{
        display:inline-block;margin-right:8px;text-decoration:none;font-weight:700;font-size:.9rem;
        padding:7px 10px;border-radius:10px;border:1px solid #e5e7eb;color:#111827;background:#fff
    }
    .users.index td.actions a:hover{background:#f3f4f6}
    .users.index td.actions form button{
        padding:7px 10px;border-radius:10px;border:1px solid #fee2e2;background:#fff1f2;color:#b91c1c;font-weight:800;cursor:pointer
    }
    .users.index .protected{
        display:inline-block;padding:7px 10px;border-radius:10px;border:1px dashed #cbd5e1;color:#64748b;background:#f8fafc;font-weight:800
    }

    .users.index .paginator{display:flex;align-items:center;justify-content:space-between;margin-top:12px}
    .users.index .pagination a,.users.index .pagination span{
        display:inline-block;margin:0 4px;padding:8px 12px;border:1px solid #e5e7eb;border-radius:10px;text-decoration:none;color:#374151
    }
    .users.index .pagination .current{background:#111827;color:#fff;border-color:#111827}
</style>

<div class="users index page">
    <div class="card">
        <div class="header">
            <div class="header-left">
                <?= $this->Html->link('← Back', ['controller' => 'Admin', 'action' => 'index'], ['class' => 'back-btn']) ?>
                <div>
                    <h3 class="title">Manage Users</h3>
                    <p class="subtitle">Add, review, and remove admin users</p>
                </div>
            </div>
            <?= $this->Html->link('＋ Add New User', ['action' => 'add'], ['class' => 'primary-btn']) ?>
        </div>

        <div class="table-wrap">
            <div class="table-frame">
                <div class="table-responsive">
                    <table id="UsersFormsTable" class="display">
                        <thead>
                        <tr>
                            <th><?= $this->Paginator->sort('email', 'Email') ?></th>
                            <th><?= $this->Paginator->sort('role', 'Role') ?></th>
                            <th><?= $this->Paginator->sort('modified', 'Modified') ?></th>
                            <th><?= $this->Paginator->sort('created', 'Created') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($users as $user): ?>
                            <?php
                            $modifiedStr = $user->modified ? $this->Time->i18nFormat($user->modified, 'yyyy-MM-dd HH:mm', $tz) : '—';
                            $createdStr  = $this->Time->i18nFormat($user->created, 'yyyy-MM-dd HH:mm', $tz);

                            $roleBadge = $user->role === 'super'
                                ? '<span class="badge-role badge-super">super</span>'
                                : '<span class="badge-role badge-admin">admin</span>';
                            ?>
                            <tr>
                                <td><?= h($user->email) ?></td>
                                <td><?= $this->Html->tag('span', $roleBadge, ['escape' => false]) ?></td>
                                <td class="mono"><?= h($modifiedStr) ?></td>
                                <td class="mono"><?= h($createdStr) ?></td>
                                <td class="actions">
                                    <?= $this->Html->link(__('View'), ['action' => 'view', $user->id]) ?>

                                    <?php if ($user->role === 'super'): ?>
                                        <span class="protected" title="Super admin cannot be deleted">Protected</span>
                                    <?php elseif ($currentIsSuper): ?>
                                        <?= $this->Form->postLink(
                                            __('Delete'),
                                            ['action' => 'delete', $user->id],
                                            ['confirm' => __('Are you sure you want to delete this user?')]
                                        ) ?>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <div class="paginator">
                    <ul class="pagination">
                        <?= $this->Paginator->prev('‹ Prev') ?>
                        <?= $this->Paginator->numbers() ?>
                        <?= $this->Paginator->next('Next ›') ?>
                    </ul>
                    <p class="subtitle"><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} users out of {{count}} total')) ?></p>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $('#UsersFormsTable').DataTable({
            paging: false,
            searching: false,
            info: false,
            lengthChange: false,
            ordering: false,
            autoWidth: false
        });
    });
</script>
