<?php
/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link          https://cakephp.org CakePHP(tm) Project
 * @since         0.10.0
 * @license       https://opensource.org/licenses/mit-license.php MIT License
 * @var \App\View\AppView $this
 */

$cakeDescription = 'CakePHP: the rapid development php framework';
$this->loadHelper('Authentication.Identity');
?>
<!DOCTYPE html>
<html>
<head>
    <?= $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>
        <?= $this->fetch('title') ?>
    </title>

    <!-- Favicon-->
    <!-- Custom Google font-->
    <!-- <link rel="preconnect" href="https://fonts.googleapis.com" /> -->
    <!-- <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin /> -->


    <?= $this->Html->meta('icon') ?>

    <link rel="stylesheet" href="https://cdn.datatables.net/2.2.2/css/dataTables.dataTables.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/2.2.2/js/dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">


    <?= $this->Html->css('styles'); ?>
    <?= $this->Html->css('https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css'); ?>
    <?= $this->Html->css('https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@100;200;300;400;500;600;700;800;900&amp;display=swap'); ?>
<!--    --><?php //= $this->Html->css(['normalize.min', 'cake', 'milligram.min', 'fonts', 'customised_utils']) ?>
    <?= $this->Html->css(['cake', 'customised_utils']) ?>


    <?= $this->Html->script('scripts'); ?>
    <?= $this->Html->script('https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js'); ?>
    <?= $this->Html->script('https://www.google.com/recaptcha/api.js'); ?>

    <?= $this->fetch('meta') ?>
    <?= $this->fetch('css') ?>
</head>


<body class="d-flex flex-column h-100">
<main class="flex-shrink-0">
    <!-- Navigation-->
    <nav class="navbar navbar-expand-lg navbar-light bg-white py-3">
        <div class="container px-5">
            <?= $this->Html->link(
                $this->Html->image('monash_logo.png', [
                    'alt' => 'Monash University',
                    'class' => 'd-inline-block align-text-top',
                    'height' => '40'
                ]),
                ['controller' => 'Ollama', 'action' => 'index'], [
                'class' => "navbar-brand",
                'escape' => false
            ]); ?>
            <!--            --><?php //= $this->Html->link('Home', ['controller' => 'Pages', 'action' => 'display'], ['class' => 'default-title']); ?>


            <!--            <a class="navbar-brand" href="index.html"><span class="fw-bolder text-primary">Start Bootstrap</span></a>-->
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                    data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                    aria-expanded="false" aria-label="Toggle navigation"><span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav ms-auto mb-2 mb-lg-0 small fw-bolder">
                    <?php if ($this->Identity->isLoggedIn()): ?>
                        <li class="nav-item">
                            <?= $this->Html->link('<i class="fas fa-tools"></i> Admin',
                                ['controller' => 'Admin', 'action' => 'index'],
                                ['class' => 'nav-link', 'escape' => false]) ?>
                        </li>
<!--                        <li class="nav-item">-->
<!--                            --><?php //= $this->Html->link('<i class="fas fa-envelope"></i> Responses',
//                                ['controller' => 'ContactForms', 'action' => 'index'],
//                                ['class' => 'nav-link','escape'=>false]) ?>
<!--                        </li>-->
                        <li class="nav-item">
                            <?= $this->Html->link('<i class="fas fa-sign-out-alt"></i> Logout',
                                ['controller' => 'Auth', 'action' => 'logout'],
                                ['class' => 'nav-link','escape'=>false]) ?>
                        </li>
                    <?php else: ?>
                        <li class="nav-item">
                            <?= $this->Html->link('<i class="fas fa-address-book"></i> Contact Us',
                                ['controller' => 'ContactForms', 'action' => 'add'],
                                ['class' => 'nav-link','escape'=>false]) ?>
                        </li>
                        <li class="nav-item">
                            <?= $this->Html->link('<i class="fas fa-sign-in-alt"></i> Login',
                                ['controller' => 'Auth', 'action' => 'Login'],
                                ['class' => 'nav-link','escape'=>false]) ?>
                        </li>
                    <?php endif; ?>
                </ul>

            </div>

        </div>
    </nav>
    <?= $this->Flash->render() ?>
    <?= $this->fetch('content') ?>
</main>
<!-- Footer-->
<footer class="bg-white py-4 mt-auto">
    <div class="container px-5">
        <div class="row align-items-center justify-content-between flex-column flex-sm-row">
            <div class="col-auto">
                <div class="small m-0">Copyright &copy; Team 003</div>
            </div>
            <div class="col-auto">
<!--                --><?php //if ($this->Identity->isLoggedIn()): ?>
<!--                    --><?php //= $this->Html->link('New Admin', ['controller' => 'Auth', 'action' => 'register'], ['class' => 'small']) ?>
<!--                    <span class="mx-1">&middot;</span>-->
<!--                --><?php //endif ?>
<!--                <a class="small" href="https://book.cakephp.org/5/en/index.html">CakePHP Cookbook - Your best friend EVER!(In FIT3047)</a>-->
<!--                <span class="mx-1">&middot;</span>-->
<!--                <a class="small" href="https://getbootstrap.com/docs/5.0">Bootstrap Documentation - Your second best friend!</a>-->
<!--                <span class="mx-1">&middot;</span>-->
<!--                <a class="small" href="#!">Contact</a>-->
            </div>
        </div>
    </div>
</footer>
<!-- Bootstrap core JS-->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
<!-- Core theme JS-->
<!--<script src="js/scripts.js"></script>-->
<?php

$this->Html->script('scripts');
$this->fetch('script');


?>
</body>
</html>
