<?php
declare(strict_types=1);

namespace App\Controller\Component;

use Cake\Controller\Component;

class FileUploadComponent extends Component{

    public function uploadToWebroot(array $file): ?string{

        if (empty($file['tmp_name']) || $file['error'] !== UPLOAD_ERR_OK){
            return null;
        }

        $uploadDir = WWW_ROOT . 'uploads' . DS;

        if (!file_exists($uploadDir)) {
            mkdir($uploadDir, 0755, true);
        }

        $filename = time() . '_' . basename($file['name']);
        $destination = $uploadDir . $filename;

        if (move_uploaded_file($file['tmp_name'], $destination)) {
            return 'uploads/' . $filename;
        }

        return null;
    }



}
