<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * ChangeRequest Entity
 *
 * @property int $id
 * @property int $user_id
 * @property string $action
 * @property int|null $faq_id
 * @property string|null $payload
 * @property string $status
 * @property int|null $reviewed_by
 * @property \Cake\I18n\DateTime|null $reviewed_at
 * @property \Cake\I18n\DateTime $created
 * @property \Cake\I18n\DateTime $modified
 *
 * @property \App\Model\Entity\User $user
 * @property \App\Model\Entity\Faq $faq
 */
class ChangeRequest extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'user_id' => true,
        'action' => true,
        'faq_id' => true,
        'payload' => true,
        'status' => true,
        'reviewed_by' => true,
        'reviewed_at' => true,
        'created' => true,
        'modified' => true,
        'user' => true,
        'faq' => true,
    ];
}
