<?php
$this->assign('title', 'Knowledge Admin');
$identity  = $this->request->getAttribute('identity');
$role      = $identity->role ?? 'admin';
$isSuper   = ($role === 'super');
$pending   = isset($pendingCount) ? (int)$pendingCount : 0;
?>
<style>
    .admin-wrap{
        max-width:1100px;
        margin:60px auto;
        padding:50px 40px;
        background:#fff;
        border-radius:20px;
        box-shadow:0 8px 30px rgba(0,0,0,.08);
        text-align:center;
    }
    .admin-title{font-size:2.4rem;margin-bottom:12px;color:#111827;font-weight:800;}
    .admin-sub{font-size:1.1rem;color:#6b7280;margin-bottom:48px;}
    .tiles{
        display:grid;
        grid-template-columns:repeat(auto-fit,minmax(240px,1fr));
        gap:28px;
        justify-items:center;
    }
    .tile{
        display:flex;align-items:center;justify-content:center;gap:12px;
        width:100%;
        padding:28px 32px;
        border-radius:18px;
        color:#fff;
        font-size:1.25rem;
        font-weight:700;
        text-decoration:none;
        box-shadow:0 8px 20px rgba(0,0,0,.12);
        transition:all .25s ease;
    }
    .tile:hover{transform:translateY(-4px) scale(1.03);}
    .g-blue{background:linear-gradient(135deg,#4f46e5,#3b82f6);}
    .g-green{background:linear-gradient(135deg,#10b981,#34d399);}
    .g-indigo{background:linear-gradient(135deg,#6366f1,#8b5cf6);}
    .g-amber{background:linear-gradient(135deg,#f59e0b,#f97316);}
    .badge{
        background:#fff;color:#111827;font-size:.85rem;
        font-weight:800;border-radius:999px;padding:4px 10px;
    }
</style>

<div class="admin-wrap">
    <h1 class="admin-title">Knowledge Repository Admin</h1>
    <p class="admin-sub">Central hub for maintaining chatbot knowledge and user access efficiently</p>

    <div class="tiles">
        <?= $this->Html->link('➕ Add New Prompt', ['controller'=>'Faqs','action'=>'add'], ['class'=>'tile g-blue']) ?>
        <?= $this->Html->link('✏️ Edit / Filter', ['controller'=>'Faqs','action'=>'index'], ['class'=>'tile g-green']) ?>

        <?php if ($isSuper): ?>
            <?= $this->Html->link(
                '✅ Approvals' . ($pending > 0 ? ' <span class="badge">'.$pending.'</span>' : ''),
                ['controller'=>'Faqs','action'=>'approved'],
                ['class'=>'tile g-indigo','escape'=>false]
            ) ?>
            <?= $this->Html->link('👤 Manage Users', ['controller'=>'Users','action'=>'index'], ['class'=>'tile g-amber']) ?>
        <?php else: ?>
            <?= $this->Html->link('📬 My Requests', ['controller'=>'Faqs','action'=>'myRequests'], ['class'=>'tile g-indigo']) ?>
        <?php endif; ?>
    </div>
</div>
