<?php
$this->assign('title', 'Forgot Password');
?>
<div class="login-bg">
    <div class="login-card">
        <div class="brand">
            <?= $this->Html->image('monash_logo.png', ['alt' => 'Monash University', 'class' => 'brand-logo']) ?>
        </div>

        <div class="avatar-wrap">
            <div class="avatar-circle">
                <i class="fas fa-key"></i>
            </div>
        </div>

        <h1 class="login-title">Forgot Password</h1>

        <p class="notice">
            Self-service password reset is <strong>not available</strong> at the moment.
            Please contact the <strong>Chatbot Manager</strong> or a <strong>Super Admin</strong> to have your password updated.
        </p>

        <?= $this->Flash->render() ?>

        <?= $this->Form->create(null, ['class' => 'login-form', 'id' => 'forgotForm']) ?>

        <div class="form-group">
            <label class="form-label">Email address</label>
            <?= $this->Form->control('email', [
                'type' => 'email',
                'required' => true,
                'autofocus' => true,
                'label' => false,
                'class' => 'form-control form-control-lg',
                'placeholder' => 'example@example.com'
            ]) ?>
        </div>

        <div class="actions mt-2">
            <?= $this->Form->button('Send request', ['class' => 'btn btn-primary btn-lg w-100']) ?>
        </div>

        <div class="aux mt-3">
            <?= $this->Html->link('Back to Login', ['controller' => 'Auth', 'action' => 'login'], ['class' => 'aux-link']) ?>
        </div>

        <?= $this->Form->end() ?>
    </div>
</div>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" integrity="sha512-1ycn6IcaQQ40/8GJ4G8j4YhZ+7Gk9Kp1K1M4nG5Yl0f4mV3x0k8m2m3Zb0rJrYH3k2c2w9m8m0Qd7vZ8x8aQ==" crossorigin="anonymous" referrerpolicy="no-referrer"/>

<style>
    :root { --card-w: 420px; }
    body, html { margin: 0; font-family: 'Segoe UI', Roboto, sans-serif; }
    .login-bg{
        min-height:100vh; display:flex; align-items:center; justify-content:center;
        background:linear-gradient(180deg,#2e6aa7 0%, #225b92 100%); padding:24px;
    }
    .login-card{
        width:100%; max-width:var(--card-w); background:#fff; border-radius:12px;
        box-shadow:0 12px 36px rgba(0,0,0,.18); padding:28px 26px 30px; text-align:center;
    }
    .brand{
        display:flex; justify-content:center; align-items:center;
        border-bottom:1px solid #eef0f4; padding-bottom:18px; margin-bottom:18px;
    }
    .brand-logo{ max-width:180px; height:auto; object-fit:contain; }
    .avatar-wrap{ display:flex; justify-content:center; align-items:center; margin:10px 0 12px; }
    .avatar-circle{
        width:70px; height:70px; border-radius:50%;
        background:linear-gradient(135deg,#6f42c1,#8d6ed5);
        display:flex; align-items:center; justify-content:center;
        color:#fff; font-size:28px; box-shadow:0 4px 15px rgba(0,0,0,.1);
    }
    .login-title{ font-size:22px; font-weight:700; margin:6px 0 12px; color:#1f2230; }
    .notice{
        background:#f6f2ff; border:1px solid #e6ddfb; color:#2a2342;
        border-radius:10px; padding:10px 12px; margin:0 0 14px;
        text-align:center;
    }
    .login-form{ text-align:left; }
    .form-group{ margin-bottom:14px; }
    .form-label{ font-weight:600; margin-bottom:6px; display:block; color:#1f2230; }
    .form-control{ border-radius:10px; padding:.9rem 1rem; border:1px solid #d7d9e0; }
    .form-control:focus{ box-shadow:0 0 0 .2rem rgba(111,66,193,.15); border-color:#8d6ed5; }
    .actions{ margin-top:6px; }
    .btn-primary{ background:#3c7be0; border-color:#3c7be0; }
    .btn-primary:hover{ background:#2f69c7; border-color:#2f69c7; }
    .aux{ text-align:center; }
    .aux-link{ color:#3c7be0; text-decoration:none; }
    .aux-link:hover{ text-decoration:underline; }
    .flash-message, .message, .error { margin-bottom:10px; text-align:center; }
    @media (max-width:420px){ .brand-logo{ max-width:150px; } }
</style>
