<?php
$this->assign('title', 'Login');
?>
<div class="login-bg">
    <div class="login-card">
        <div class="brand">
            <?= $this->Html->image('monash_logo.png', [
                'alt' => 'Monash University',
                'class' => 'brand-logo'
            ]) ?>
        </div>

        <div class="avatar-wrap">
            <div class="avatar-circle">
                <i class="fas fa-user"></i>
            </div>
        </div>

        <h1 class="login-title">Sign In</h1>

        <?= $this->Form->create(null, ['id' => 'loginForm', 'class' => 'login-form']) ?>

        <div class="form-group">
            <label class="form-label">Email address</label>
            <?= $this->Form->control('email', [
                'label' => false,
                'required' => true,
                'class' => 'form-control form-control-lg',
                'placeholder' => 'example@example.com'
            ]) ?>
        </div>

        <div class="form-group">
            <label class="form-label">Password</label>
            <?= $this->Form->control('password', [
                'label' => false,
                'required' => true,
                'class' => 'form-control form-control-lg',
                'placeholder' => 'Enter your password'
            ]) ?>
        </div>

        <div class="recaptcha-wrap">
            <div class="g-recaptcha" data-sitekey="6Lf00OIrAAAAAAsCpfgy2FAVnI99plH-jhxH61y8"></div>
        </div>

        <div class="mt-2">
            <?= $this->Flash->render() ?>
        </div>

        <div class="actions mt-3">
            <?= $this->Form->button('Next', ['class' => 'btn btn-primary btn-lg w-100']) ?>
        </div>

        <div class="aux mt-3">
            <?= $this->Html->link("Can't login", ['controller' => 'Auth', 'action' => 'forgetPassword'], ['class' => 'aux-link']) ?>
        </div>

        <?= $this->Form->end() ?>
    </div>
</div>

<script src="https://www.google.com/recaptcha/api.js" async defer></script>
<script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>

<style>
    :root { --card-w: 420px; --brand-blue:#1f5b8f; }
    body, html { margin:0; font-family:'Segoe UI', Roboto, sans-serif; }
    .login-bg{
        min-height:100vh; display:flex; align-items:center; justify-content:center;
        background:linear-gradient(180deg,#2e6aa7 0%, #225b92 100%); padding:24px;
    }
    .login-card{
        width:100%; max-width:var(--card-w); background:#fff; border-radius:12px;
        box-shadow:0 12px 36px rgba(0,0,0,.18); padding:28px 26px 30px; text-align:center;
    }
    .brand{
        display:flex; justify-content:center; align-items:center;
        border-bottom:1px solid #eef0f4; padding-bottom:18px; margin-bottom:18px;
    }
    .brand-logo{ max-width:180px; height:auto; object-fit:contain; }
    .avatar-wrap{ display:flex; justify-content:center; align-items:center; margin:10px 0 15px; }
    .avatar-circle{
        width:70px; height:70px; border-radius:50%;
        background:linear-gradient(135deg,#6f42c1,#8d6ed5);
        display:flex; align-items:center; justify-content:center;
        color:#fff; font-size:30px; box-shadow:0 4px 15px rgba(0,0,0,.1);
    }
    .login-title{ font-size:22px; font-weight:700; margin:10px 0 16px; color:#1f2230; }
    .login-form{ text-align:left; }
    .form-group{ margin-bottom:14px; }
    .form-label{ font-weight:600; margin-bottom:6px; display:block; color:#1f2230; }
    .form-control{ border-radius:10px; padding:.9rem 1rem; border:1px solid #d7d9e0; }
    .form-control:focus{ box-shadow:0 0 0 .2rem rgba(111,66,193,.15); border-color:#8d6ed5; }
    .recaptcha-wrap{ display:flex; justify-content:center; margin:10px 0 6px; }
    .actions{ margin-top:8px; }
    .btn-primary{ background:#3c7be0; border-color:#3c7be0; }
    .btn-primary:hover{ background:#2f69c7; border-color:#2f69c7; }
    .aux{ text-align:center; }
    .aux-link{ color:#3c7be0; text-decoration:none; }
    .aux-link:hover{ text-decoration:underline; }
    .flash-message, .message, .error { margin-bottom:10px; text-align:center; }
    @media (max-width: 420px){
        .brand-logo{ max-width:150px; }
    }
</style>
