<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\ContactForm> $contactForms
 */
?>
<div class="contactForms index content table-container container">

    <h3 class="form-title"><?= __('Contact Responses') ?></h3>

    <div class="table-responsive" id="datatable" style="padding: 10px">
        <table id="contactFormsTable" class="display">
            <thead>
            <tr>
                <th><?= $this->Paginator->sort('name') ?></th>
                <th><?= $this->Paginator->sort('created') ?></th>
                <th><?= $this->Paginator->sort('message') ?></th>
                <th><?= $this->Paginator->sort('email') ?></th>

                <th class="actions"><?= __('Actions') ?></th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($contactForms as $contactForm): ?>
                <tr>
                    <td><?= h($contactForm->name) ?></td>



<!--                    First we need to use dataorder let the datatable know it is date format.-->
                    <td data-order="<?= $contactForm->created ?>">
                        <?= h($contactForm->created->format('d/M/Y ( h:i A )')) ?>
                    </td>


                    <td class="customTD"><?= h($contactForm->message) ?></td>
                    <td><a href="mailto:<?= h($contactForm->email) ?>"><?= h($contactForm->email) ?></td>


                    <td>
                    <div class = "d-inline-flex p-2">
                        <?= $this->Html->link(__('Details'), ['action' => 'view', $contactForm->id], ['class' => 'btn btn-info mx-2']) ?>
                        <a class = "btn btn-dark mx-2" href="mailto:<?= $contactForm->email ?>">Email</a>
            </div>
        </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
    $(document).ready(function() {
        $('#contactFormsTable').DataTable({
            //We then need to make 1st index column which is date as descending.
            order: [[1, 'desc']],


            //only allow search to be allowed with 2nd and 3rd col
            columnDefs: [
                {
                    targets: [0, 1],
                    searchable: false
                },
                {
                    targets: [2, 3],
                    searchable: true
                }
            ]
        });
    });


</script>

