<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\User $user
 */
?>
<div class="row">
    <div class="col-12 col-md-10 offset-md-1">
        <div class="card shadow-sm p-4 mt-4">
            <div class="d-flex gap-2 mb-2">
             <?= $this->Html->link('← Back to Users', ['action' => 'index'], ['class' => 'btn btn-outline-secondary']) ?>
            </div>

            <h2 class="mb-4 text-center"><?= __('Add New User') ?></h2>

            <?= $this->Form->create($user, ['class' => 'needs-validation']) ?>

            <div class="mb-3">
                <?= $this->Form->control('email', [
                    'type' => 'email',
                    'label' => 'Email',
                    'class' => 'form-control',
                    'required' => true,
                    'maxlength' => 255,
                    'placeholder' => 'name@example.com',
                    'autocomplete' => 'email'
                ]) ?>
                <div class="form-text">Must be unique. We recommend an admin email domain.</div>
            </div>

            <div class="mb-3">
                <label for="password-input" class="form-label">Password</label>
                <div class="input-group">
                    <?= $this->Form->control('password', [
                        'type' => 'password',
                        'label' => false,
                        'id' => 'password-input',
                        'class' => 'form-control',
                        'required' => true,
                        'minlength' => 8,
                        'placeholder' => 'At least 8 characters',
                        'autocomplete' => 'new-password'
                    ]) ?>
                    <button class="btn btn-outline-secondary" type="button" id="toggle-pass">Show</button>
                    <button class="btn btn-outline-secondary" type="button" id="gen-pass" title="Generate a strong password">Generate</button>
                </div>
                <div class="form-text">Use 8+ characters. Mix letters, numbers, and symbols.</div>
                <div id="pass-meter" class="mt-2 small text-muted"></div>
            </div>

            <div class="text-center mt-3">
                <?= $this->Form->button(__('Create User'), [
                    'type' => 'submit',
                    'class' => 'btn btn-primary btn-lg px-5'
                ]) ?>
                <?= $this->Html->link(__('Cancel'), ['action' => 'index'], [
                    'class' => 'btn btn-outline-secondary ms-2'
                ]) ?>
            </div>

            <?= $this->Form->end() ?>
        </div>
    </div>
</div>

<style>
    /* Optional: small polish if Bootstrap is present */
    input.form-control.is-invalid { border-color: #dc3545; }
</style>

<script>
    // Show/Hide password
    (() => {
        const input = document.getElementById('password-input');
        const btn   = document.getElementById('toggle-pass');
        const gen   = document.getElementById('gen-pass');
        const meter = document.getElementById('pass-meter');

        if (!input || !btn) return;

        btn.addEventListener('click', () => {
            const isPwd = input.getAttribute('type') === 'password';
            input.setAttribute('type', isPwd ? 'text' : 'password');
            btn.textContent = isPwd ? 'Hide' : 'Show';
            input.focus();
        });

        // Simple generator
        function generatePassword(len = 14) {
            const chars = 'ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz23456789!@#$%^&*()-_=+';
            let out = '';
            for (let i=0;i<len;i++) out += chars.charAt(Math.floor(Math.random()*chars.length));
            return out;
        }

        if (gen) {
            gen.addEventListener('click', () => {
                input.value = generatePassword();
                input.dispatchEvent(new Event('input'));
                if (input.getAttribute('type') === 'password') {
                    input.setAttribute('type', 'text');
                    btn.textContent = 'Hide';
                }
                input.focus();
            });
        }

        // Lightweight strength hint
        function strengthHint(v) {
            let score = 0;
            if (v.length >= 8) score++;
            if (/[A-Z]/.test(v) && /[a-z]/.test(v)) score++;
            if (/\d/.test(v)) score++;
            if (/[^A-Za-z0-9]/.test(v)) score++;
            const labels = ['Very weak', 'Weak', 'Okay', 'Good', 'Strong'];
            return labels[score] || labels[0];
        }

        input.addEventListener('input', () => {
            if (!meter) return;
            const v = (input.value || '');
            meter.textContent = v ? `Strength: ${strengthHint(v)}` : '';
        });
    })();
</script>
