<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\User $user
 */
$this->assign('title', 'User Details');

$tz = 'Australia/Melbourne';
$identity = $this->request->getAttribute('identity');
$currentIsSuper = (bool)($identity && $identity->role === 'super');

$modifiedStr = $user->modified ? $this->Time->i18nFormat($user->modified, 'yyyy-MM-dd HH:mm', $tz) : '—';
$createdStr  = $this->Time->i18nFormat($user->created,  'yyyy-MM-dd HH:mm', $tz);

$roleBadgeHtml = $user->role === 'super'
    ? '<span class="ud-badge ud-badge--super">super</span>'
    : '<span class="ud-badge ud-badge--admin">admin</span>';
?>
<style>
    .ud-wrap{max-width:900px;margin:40px auto;padding:0 16px}
    .ud-card{background:#fff;border:1px solid #eaeaea;border-radius:16px;box-shadow:0 6px 24px rgba(0,0,0,.06)}
    .ud-header{display:flex;align-items:center;justify-content:space-between;padding:18px 20px}
    .ud-title{margin:0;font-size:1.25rem;font-weight:800;color:#0f172a}
    .ud-sub{margin:0;color:#64748b;font-size:.95rem}
    .ud-actions a, .ud-actions form button{
        display:inline-flex;align-items:center;gap:8px;
        padding:8px 12px;border-radius:10px;font-weight:700;
        text-decoration:none;border:1px solid #e5e7eb;background:#fff;color:#111827;
    }
    .ud-actions a:hover{background:#f3f4f6}
    .ud-danger{border-color:#fecaca;background:#fff1f2;color:#b91c1c}

    .ud-body{padding:8px 20px 20px}
    .ud-table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0;
        border-bottom: 1px solid #eef2f7;
    }
    .ud-table th {
        border-bottom: 1px solid #e91e63;
    }
    .ud-table td {
        border-bottom: 1px solid #e91e63;
    }
    .ud-table tr:last-child td {
        border-bottom: 1px solid #e91e63;
    }

    .mono{font-family:ui-monospace,SFMono-Regular,Menlo,Monaco,Consolas,"Liberation Mono",monospace}

    .ud-badge{display:inline-block;padding:4px 10px;border-radius:999px;font-weight:800;font-size:.8rem}
    .ud-badge--super{background:#dbeafe;color:#1e40af;border:1px solid #bfdbfe}
    .ud-badge--admin{background:#ecfdf5;color:#065f46;border:1px solid #d1fae5}
</style>

<div class="ud-wrap">
    <div class="ud-card">
        <div class="ud-header">
            <div>
                <h3 class="ud-title"><?= h($user->email) ?></h3>
                <p class="ud-sub">User profile & metadata</p>
            </div>
            <div class="ud-actions">
                <?= $this->Html->link('← Back', ['controller' => 'Users', 'action' => 'index'], ['class' => '']) ?>
                <?php if ($currentIsSuper && $user->role !== 'super'): ?>
                    <?= $this->Form->postLink(
                        'Delete',
                        ['controller' => 'Users', 'action' => 'delete', $user->id],
                        ['confirm' => __('Are you sure you want to delete this user?'), 'class' => 'ud-danger']
                    ) ?>
                <?php endif; ?>
            </div>
        </div>

        <div class="ud-body">
            <table class="ud-table">
                <tr>
                    <th><?= __('Email') ?></th>
                    <td><?= h($user->email) ?></td>
                </tr>
                <tr>
                    <th><?= __('Role') ?></th>
                    <td><?= $this->Html->tag('span', $roleBadgeHtml, ['escape' => false]) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td class="mono">#<?= (int)$user->id ?></td>
                </tr>
                <tr>
                    <th><?= __('Modified') ?></th>
                    <td class="mono"><?= h($modifiedStr) ?></td>
                </tr>
                <tr>
                    <th><?= __('Created') ?></th>
                    <td class="mono"><?= h($createdStr) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
